<div class="min-h-[calc(100vh-152px)] space-y-6 text-[15px]">
    <h2 class="text-lg font-medium text-slate-600 dark:text-white">Almoço</h2>

    <?php
    date_default_timezone_set('America/Sao_Paulo');

    $token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);
    $data = date('Y-m-d H:i:s');
    $time = date("H:i");
    $totalFinal = 0;

    $action = filter_input(INPUT_GET, 'action', FILTER_DEFAULT);
    if ($action) :
        require('_models/Mesas.class.php');

        $postAction = filter_input(INPUT_GET, 'mesa', FILTER_VALIDATE_INT);
        $fecharMesa = filter_input(INPUT_GET, 'mesa_id', FILTER_VALIDATE_INT);
        $postUpdate = new Mesas;

        switch ($action):
            case 'delete':
                $postUpdate->ExeDelete($postAction);
                WSErro($postUpdate->getError()[0], $postUpdate->getError()[1]);
                break;

            case 'fecharmesa':
                $postUpdate->ExeStatusMesa($fecharMesa, '', 0, '', $token);
                WSErro($postUpdate->getError()[0], $postUpdate->getError()[1]);
                header('Location: painel.php?exe=restaurante/index');
                break;

            default:
                WSErro("Ação não foi identifica pelo sistema, favor utilize os botões!", WS_ALERT);
        endswitch;
    endif;

    $post = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    if (isset($post) && $post['SendPostForm']) :
        unset($post['SendPostForm']);

        $dados = new Read;
        $dados->ExeRead(DB_PRODUTOS, "WHERE cod = {$post['cod']}");
        $dd = $dados->getResult()[0];

        $post['preco'] = $dd['preco'];
        $post['nome'] = $dd['nome'];
        $post['data'] = date('Y-m-d');
        $post['time'] = date("h:i:s");
        $post['ncliente'] = 2;

        require('_models/Almoco.class.php');
        $cadastra = new Almoco;
        $cadastra->ExeCreate($post);

        if ($cadastra->getResult()) :
            header('Location: painel.php?exe=restaurante/almoco&create=true&token=' . $token);
        else :
            WSErro($cadastra->getError()[0], $cadastra->getError()[1]);
        endif;
    endif;

    $actionn = filter_input(INPUT_GET, 'actionn', FILTER_DEFAULT);
    if ($actionn) :

        require('_models/Almoco.class.php');
        $postAction = filter_input(INPUT_GET, 'itemid', FILTER_VALIDATE_INT);
        $postUpdate = new Almoco;

        switch ($actionn):
            case 'delete':
                $postUpdate->ExeDelete($postAction);
                WSErro($postUpdate->getError()[0], $postUpdate->getError()[1]);
                break;

            default:
                WSErro("Ação não foi identifica pelo sistema, favor utilize os botões!", WS_ALERT);
        endswitch;
    endif;

    $checkCreate = filter_input(INPUT_GET, 'create', FILTER_VALIDATE_BOOLEAN);
    if ($checkCreate && empty($cadastra)) :
        WSErro("Lançamento realizado com sucesso!", WS_ACCEPT);
    endif;
    ?>
    <script>
        function NovaJanela(pagina, nome, w, h, scroll) {
            LeftPosition = (screen.width) ? (screen.width - w) / 2 : 0;
            TopPosition = (screen.height) ? (screen.height - h) / 2 : 0;
            settings = 'height=' + h + ',width=' + w + ',top=' + TopPosition + ',left=' + LeftPosition + ',scrollbars=' + scroll + ',resizable'
            win = window.open(pagina, nome, settings);
        }
    </script>
    <form name="PostForm" action="" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="<?= $token; ?>" />
        <div class="grid grid-cols-1 gap-6 xl:grid-cols-1">
            <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
                <div class="grid grid-cols-2 gap-6">
                    <div class="relative">
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Escolha o produto</label>
                        <select name="cod" class="form-select">
                            <option value="">Selecione</option>
                            <?php
                            $produtos = new Read;
                            $produtos->ExeRead(DB_PRODUTOS, " ORDER BY nome ASC");
                            foreach ($produtos->getResult() as $produto) :
                                extract($produto);
                            ?>
                                <option value="<?= $cod; ?>"><?= $nome; ?></option>
                            <?php
                            endforeach;
                            ?>
                        </select>
                    </div>
                    <div class="relative">
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Informe a quantidade</label>
                        <input type="number" name="qtd" class="form-input">
                    </div>
                </div>
                </br>
                <input type="submit" class="btn border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 dark:disabled:bg-white/10 dark:disabled:border-white/10 disabled:bg-gray-300 disabled:border-gray-300 hover:bg-indigo-700" value="Lançar" name="SendPostForm" />
            </div>
        </div>
    </form>

    <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10 order-8">
        <div class="flex items-start justify-between gap-3 mb-6">
            <h5 class="text-lg leading-[26px] font-medium">Produtos lançados</h5>
        </div>
        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Produto</th>
                        <th class="text-center">QTD</th>
                        <th class="text-center">Unitário</th>
                        <th class="text-center">Total</th>
                        <th>Ação</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $carrinho = new Read;
                    $carrinho->FullRead("SELECT *, SUM(qtd) AS qt, SUM(preco) AS pr FROM " . DB_CARRINHO . " WHERE token='{$token}' GROUP BY cod");
                    foreach ($carrinho->getResult() as $carro) :
                        extract($carro);

                        $totalProduto = $pr * $qt;

                        $totalFinal += $pr;
                    ?>
                        <tr>
                            <td><?= $nome; ?></td>
                            <td class="text-center"><?= $qt; ?></td>
                            <td class="text-center"><?= number_format($preco, 2, ',', '.'); ?></td>
                            <td class="text-center"><?= number_format($preco * $qt, 2, ',', '.'); ?></td>
                            <td>
                                <a href="painel.php?exe=restaurante/almoco&itemid=<?= $id; ?>&token=<?= $token; ?>&actionn=delete">
                                    <svg xmlns="https://www.w3.org/2000/svg" width="20" height="20" fill="currentcolor" viewbox="0 0 256 256">
                                        <path d="M216,48H176V40a24,24,0,0,0-24-24H104A24,24,0,0,0,80,40v8H40a8,8,0,0,0,0,16h8V208a16,16,0,0,0,16,16H192a16,16,0,0,0,16-16V64h8a8,8,0,0,0,0-16ZM96,40a8,8,0,0,1,8-8h48a8,8,0,0,1,8,8v8H96Zm96,168H64V64H192ZM112,104v64a8,8,0,0,1-16,0V104a8,8,0,0,1,16,0Zm48,0v64a8,8,0,0,1-16,0V104a8,8,0,0,1,16,0Z"></path>
                                    </svg>
                                </a>
                            </td>
                        </tr>
                    <?php
                    endforeach;
                    ?>
                </tbody>
            </table>
        </div>

        <div class="table-responsive">
            <table>
                <tbody>
                    <tr>
                        <td class="whitespace-nowrap" style="font-size: 20px !important;"><b>TOTAL</b></td>
                        <td class="text-right" style="font-size: 20px !important;"><b>R$ <?= number_format($totalFinal, 2, ',', '.'); ?></b></td>
                    </tr>
                    <tr>
                        <td class="whitespace-nowrap" style="font-size: 20px !important;"><a href="system/restaurante/imprimir_almoco.php?token=<?= $token; ?>" target="_blank" class="btn border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 relative top-0 hover:-top-1" onclick="NovaJanela(this.href,'nomeJanela','750','600','yes');return false">Imprimir conta</a></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>