<?php
ob_start();
session_start();
require('./_app/Config.inc.php');

$login = new Login(1);
$logoff = filter_input(INPUT_GET, 'logoff', FILTER_VALIDATE_BOOLEAN);
$getexe = filter_input(INPUT_GET, 'exe', FILTER_DEFAULT);

if (!$login->CheckLogin()):
    unset($_SESSION['userlogin']);
    header('Location: index.php?exe=restrito');
else:
    $userlogin = $_SESSION['userlogin'];
endif;

if ($logoff):
    unset($_SESSION['userlogin']);
    header('Location: index.php?exe=logoff');
endif;
function getRandomStringMd5($length = 16)
{
    $string = md5(rand());
    $randomString = substr($string, 0, $length);
    return $randomString;
}

$configuracoes = new Read;
$configuracoes->ExeRead(DB_CONFIG, " WHERE id_conf = 0");
$config = $configuracoes->getResult()[0];
?>
<!DOCTYPE html>
<html x-data="main" class="dark">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="description" content="Edgar Magalhães" />
    <meta name="author" content="Edgar Magalhães" />

    <title><?= SYSNAME; ?></title>

    <link rel="shortcut icon" href="assets/images/favicon.ico" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/perfect-scrollbar.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
</head>

<body x-data="main"
    class="collapse-menu overflow-x-hidden bg-lightwhite font-public text-base font-normal text-slate-600 antialiased dark:bg-darkblue dark:text-indigo-300"
    :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.fullscreen ? '' : '']">
    <div x-cloak class="fixed inset-0 z-40 bg-slate-800/50 lg:hidden" :class="{'hidden' : !$store.app.sidebar}"
        @click="$store.app.toggleSidebar()"></div>

    <div>
        <div class="flex min-h-screen w-full items-stretch">

            <nav class="sidebar">
                <div class="brand-logo">
                    <a href="painel.php" class="flex items-center">
                        <div class="block min-h-[1px] shrink-0 grow-0 overflow-hidden leading-none">
                            <svg width="42" height="35" viewbox="0 0 42 35" fill="none"
                                xmlns="https://www.w3.org/2000/svg">
                                <path
                                    d="M36.5688 1.64243L36.3926 1.42819C36.0453 1.00627 35.6135 0.661729 35.125 0.416736C34.6365 0.171743 34.1022 0.031728 33.5563 0.00568853C33.0105 -0.0203509 32.4652 0.0681618 31.9556 0.265543C31.446 0.462925 30.9834 0.764794 30.5975 1.15173L30.0792 1.66662L28.1544 3.59484C30.1725 2.98666 31.9867 3.41861 32.9923 4.51403C33.0959 4.64188 33.2031 4.76628 33.3033 4.90105C35.075 7.27331 36.1518 10.0917 36.4132 13.041C36.6746 15.9902 36.1103 18.9541 34.7835 21.601C33.4567 24.2479 31.4197 26.4735 28.9003 28.0288C26.3809 29.5841 23.4784 30.4079 20.5176 30.4079C17.5568 30.4079 14.6543 29.5841 12.1349 28.0288C9.61545 26.4735 7.57842 24.2479 6.25161 21.601C4.92481 18.9541 4.36057 15.9902 4.622 13.041C4.88342 10.0917 5.9602 7.27331 7.7319 4.90105C7.83211 4.76628 7.94268 4.63843 8.04635 4.50712C9.08303 3.41861 10.8765 2.98666 12.8842 3.59484L10.9594 1.66662L10.4687 1.15173C10.0833 0.764958 9.62133 0.463068 9.11235 0.265448C8.60336 0.067829 8.05868 -0.0211498 7.51327 0.00423323C6.96786 0.0296162 6.43379 0.168796 5.94537 0.412834C5.45694 0.656872 5.02494 1.00037 4.67715 1.42127L4.49745 1.64243C2.08193 4.6628 0.568539 8.30397 0.131521 12.1467C-0.305497 15.9894 0.351646 19.8774 2.02727 23.363C3.70289 26.8487 6.32885 29.7902 9.60282 31.849C12.8768 33.9077 16.6657 35 20.5331 35C24.4006 35 28.1895 33.9077 31.4634 31.849C34.7374 29.7902 37.3634 26.8487 39.039 23.363C40.7146 19.8774 41.3718 15.9894 40.9347 12.1467C40.4977 8.30397 38.9843 4.6628 36.5688 1.64243Z"
                                    fill="url(#paint0_linear_39_54)" />
                                <path
                                    d="M31.3439 13.661C31.3439 11.9609 30.8118 11.5151 31.3c716 9.65253C31.3716 9.65253 30.5975 10.4197 30.5975 10.4162L29.9617 11.059C29.7683 11.2605 29.6275 11.5064 29.5516 11.7752C29.4757 12.0439 29.467 12.3272 29.5263 12.6001C29.6473 13.2043 29.7086 13.8189 29.7094 14.4351C29.7097 15.7187 29.4407 16.9882 28.9196 18.1613C28.3985 19.3345 27.6371 20.3852 26.6845 21.2457C25.7319 22.1061 24.6093 22.757 23.3893 23.1564C22.1694 23.5558 20.8792 23.6947 19.6022 23.5642C18.3252 23.4337 17.0897 23.0367 15.9758 22.3988C14.8618 21.761 13.8941 20.8964 13.1352 19.8611C12.3763 18.8258 11.8431 17.6427 11.5701 16.3884C11.2971 15.1341 11.2904 13.8365 11.5503 12.5794C11.6101 12.313 11.6022 12.0359 11.5274 11.7733C11.4525 11.5107 11.3131 11.2711 11.1218 11.0762L10.4687 10.437L9.69812 9.66635C10.2545 11.5289 9.6981 11.9747 9.72575 13.6748C9.70847 13.9306 9.69812 14.1897 9.69812 14.4523C9.74884 17.2925 10.9127 19.9991 12.9391 21.9897C14.9655 23.9802 17.6926 25.0956 20.5331 25.0956C23.3737 25.0956 26.1007 23.9802 28.1271 21.9897C30.1536 19.9991 31.3174 17.2925 31.3681 14.4523C31.3681 14.1897 31.3681 13.9306 31.337 13.6748L31.3439 13.661Z"
                                    fill="#7B3AED" />
                                <path
                                    d="M31.3232 6.88801C30.2658 7.54457 29.1739 7.77609 28.4482 7.04696C28.2685 6.85345 28.0819 6.6634 27.8849 6.48371C27.5153 6.14767 27.0304 5.96699 26.531 5.97922C26.0316 5.99145 25.5561 6.19564 25.2034 6.54937L21.8031 9.94967C21.0255 10.7551 20.5738 11.8199 20.5349 12.9388C20.496 11.8199 20.0442 10.7551 19.2667 9.94967L15.8733 6.55282C15.5204 6.19808 15.0442 5.99326 14.544 5.98102C14.0438 5.96879 13.5581 6.1501 13.1883 6.48716C12.9913 6.66685 12.8047 6.85691 12.625 7.05388C11.8959 7.78301 10.8039 7.55149 9.74652 6.89493L11.3326 8.48104L11.4363 8.58471L12.6458 9.7907L16.8409 13.9893C18.4304 15.5823 20.0546 17.4068 20.5349 19.3523C21.0152 17.4068 22.6393 15.5823 24.2324 13.9893L28.4378 9.78034L28.6728 9.54536L29.744 8.47413L31.3232 6.88801Z"
                                    fill="url(#paint1_linear_39_54)" />
                                <defs>
                                    <lineargradient id="paint0_linear_39_54" x1="38.0882" y1="9.72784e-08" x2="6.86275"
                                        y2="30.8824" gradientunits="userSpaceOnUse">
                                        <stop stop-color="#7B3AED" />
                                        <stop offset="1" stop-color="#4F46E5" />
                                    </linearGradient>
                                    <lineargradient id="paint1_linear_39_54" x1="36.0294" y1="-0.686275" x2="5.49023"
                                        y2="29.1667" gradientunits="userSpaceOnUse">
                                        <stop stop-color="#7B3AED" />
                                        <stop offset="1" stop-color="#4F46E5" />
                                    </linearGradient>
                                </defs>
                            </svg>
                        </div>
                        <p
                            class="ml-2 shrink-0 text-2xl font-bold -tracking-[0.5px] text-slate-600 opacity-100 transition-opacity duration-1000 dark:text-indigo-100">
                            <?= SYSNAME; ?>
                        </p>
                    </a>
                    <a href="javascript:;" @click="$store.app.toggleSidebar()" class="sidebar-toggle">
                        <svg class="align-middle text-white transition-all duration-300"
                            xmlns="https://www.w3.org/2000/svg" width="24" height="24" viewbox="0 0 24 24"
                            fill="currentcolor">
                            <path d="M13.293 6.293 7.586 12l5.707 5.707 1.414-1.414L10.414 12l4.293-4.293z"></path>
                        </svg>
                    </a>
                </div>

                <ul class="perfect-scrollbar menu-sidebar py-1" x-data="{ activeMenu: 'dashboard' }">
                    <li class="menu-item" :class="{'active' : activeMenu === 'dashboard'}">
                        <a href="painel.php" class="menu-link"
                            @click="activeMenu === 'dashboard' ? activeMenu = null : activeMenu = 'dashboard'">
                            <svg xmlns="https://www.w3.org/2000/svg" class="menu-icon" width="20" height="20"
                                fill="currentcolor" viewbox="0 0 256 256">
                                <path
                                    d="M240,208H224V115.55a16,16,0,0,0-5.17-11.78l-80-75.48a1.14,1.14,0,0,1-.11-.11,16,16,0,0,0-21.53,0l-.11.11L37.17,103.77A16,16,0,0,0,32,115.55V208H16a8,8,0,0,0,0,16H240a8,8,0,0,0,0-16ZM48,115.55l.11-.1L128,40l79.9,75.43.11.1V208H160V160a16,16,0,0,0-16-16H112a16,16,0,0,0-16,16v48H48ZM144,208H112V160h32Z">
                                </path>
                            </svg>
                            <p>Principal</p>
                        </a>
                    </li>
                    <li class="menu-item" :class="{'active' : activeMenu === 'mesas'}">
                        <a href="painel.php?exe=restaurante/mesas" class="menu-link"
                            @click="activeMenu === 'mesas' ? activeMenu = null : activeMenu = 'mesas'">
                            <svg xmlns="https://www.w3.org/2000/svg" class="menu-icon" width="20" height="20"
                                fill="currentcolor" viewbox="0 0 256 256">
                                <path
                                    d="M216,80H184V48a16,16,0,0,0-16-16H40A16,16,0,0,0,24,48V176a8,8,0,0,0,13,6.22L72,154V184a16,16,0,0,0,16,16h93.59L219,230.22a8,8,0,0,0,5,1.78,8,8,0,0,0,8-8V96A16,16,0,0,0,216,80ZM66.55,137.78,40,159.25V48H168v88H71.58A8,8,0,0,0,66.55,137.78ZM216,207.25l-26.55-21.47a8,8,0,0,0-5-1.78H88V152h80a16,16,0,0,0,16-16V96h32Z">
                                </path>
                            </svg>
                            <p>Mesas</p>
                        </a>
                    </li>

                    <li class="menu-item" :class="{'active' : activeMenu === 'balcao'}">
                        <a href="painel.php?exe=restaurante/balcao&token=<?= getRandomStringMd5();?>" class="menu-link"
                            @click="activeMenu === 'balcao' ? activeMenu = null : activeMenu = 'balcao'">
                            <svg xmlns="https://www.w3.org/2000/svg" class="menu-icon" width="20" height="20"
                                fill="currentcolor" viewbox="0 0 256 256">
                                <path
                                    d="M216,80H184V48a16,16,0,0,0-16-16H40A16,16,0,0,0,24,48V176a8,8,0,0,0,13,6.22L72,154V184a16,16,0,0,0,16,16h93.59L219,230.22a8,8,0,0,0,5,1.78,8,8,0,0,0,8-8V96A16,16,0,0,0,216,80ZM66.55,137.78,40,159.25V48H168v88H71.58A8,8,0,0,0,66.55,137.78ZM216,207.25l-26.55-21.47a8,8,0,0,0-5-1.78H88V152h80a16,16,0,0,0,16-16V96h32Z">
                                </path>
                            </svg>
                            <p>Balcão</p>
                        </a>
                    </li>

                    <?php
                    if ($userlogin['user_level'] == 3):
                        ?>
                        <li class="menu-item" :class="{'active' : activeMenu === 'financeiro'}">
                            <a href="javascript:void(0);" class="menu-link menu-toggle"
                                @click="activeMenu === 'financeiro' ? activeMenu = null : activeMenu = 'financeiro'">
                                <svg xmlns="https://www.w3.org/2000/svg" class="menu-icon" width="20" height="20"
                                    fill="currentcolor" viewbox="0 0 256 256">
                                    <path
                                        d="M184,112a8,8,0,0,1-8,8H112a8,8,0,0,1,0-16h64A8,8,0,0,1,184,112Zm-8,24H112a8,8,0,0,0,0,16h64a8,8,0,0,0,0-16Zm48-88V208a16,16,0,0,1-16,16H48a16,16,0,0,1-16-16V48A16,16,0,0,1,48,32H208A16,16,0,0,1,224,48ZM48,208H72V48H48Zm160,0V48H88V208H208Z">
                                    </path>
                                </svg>
                                <p>Financeiro/Relatórios</p>
                            </a>
                            <ul class="menu-sub" x-cloak x-show="activeMenu === 'financeiro'" x-collapse>

                                <?php
                                $caixa = new Read;
                                $caixa->ExeRead(DB_CAIXA, " WHERE caixa_situacao = 1");

                                if ($caixa->getResult()):
                                    $abertura = $caixa->getResult()[0];
                                    ?>
                                    <li class="menu-item">
                                        <a href="painel.php?exe=financeiro/end_caixa&caixa_id=<?= $abertura['caixa_id']; ?>"
                                            class="menu-link">
                                            <p>Fechar caixa</p>
                                        </a>
                                    </li>
                                    <?php
                                else:
                                    ?>
                                    <li class="menu-item">
                                        <a href="painel.php?exe=financeiro/create_caixa" class="menu-link">
                                            <p>Abrir caixa</p>
                                        </a>
                                    </li>
                                    <?php
                                endif;
                                ?>

                                <li class="menu-item">
                                    <a href="painel.php?exe=financeiro/index_caixa" class="menu-link">
                                        <p>Listar caixa</p>
                                    </a>
                                </li>

                                <?php
                                $caixa = new Read;
                                $caixa->ExeRead(DB_CAIXA, " WHERE caixa_situacao = 1");

                                if ($caixa->getResult()):
                                    $abertura = $caixa->getResult()[0];
                                    ?>
                                    <li class="menu-item">
                                        <a href="painel.php?exe=financeiro/create_sangria&caixa_id=<?= $abertura['caixa_id']; ?>"
                                            class="menu-link">
                                            <p>Cadastrar sangria</p>
                                        </a>
                                    </li>

                                    <li class="menu-item">
                                        <a href="painel.php?exe=financeiro/index_sangria" class="menu-link">
                                            <p>Listar sangrias</p>
                                        </a>
                                    </li>
                                    <?php
                                else:
                                    ?>
                                    <li class="menu-item">
                                        <a href="painel.php?exe=financeiro/index_sangria" class="menu-link">
                                            <p>Listar sangrias</p>
                                        </a>
                                    </li>
                                    <?php
                                endif;
                                ?>
                            </ul>
                        </li>
                        <?php
                    endif;
                    ?>

                    <?php
                    if ($userlogin['user_level'] == 3):
                        ?>
                        <li class="menu-item" :class="{'active' : activeMenu === 'produtos'}">
                            <a href="painel.php?exe=produtos/new_index" class="menu-link"
                                @click="activeMenu === 'produtos' ? activeMenu = null : activeMenu = 'produtos'">
                                <svg xmlns="https://www.w3.org/2000/svg" class="menu-icon" width="20" height="20"
                                    fill="currentcolor" viewbox="0 0 256 256">
                                    <path
                                        d="M216,80H184V48a16,16,0,0,0-16-16H40A16,16,0,0,0,24,48V176a8,8,0,0,0,13,6.22L72,154V184a16,16,0,0,0,16,16h93.59L219,230.22a8,8,0,0,0,5,1.78,8,8,0,0,0,8-8V96A16,16,0,0,0,216,80ZM66.55,137.78,40,159.25V48H168v88H71.58A8,8,0,0,0,66.55,137.78ZM216,207.25l-26.55-21.47a8,8,0,0,0-5-1.78H88V152h80a16,16,0,0,0,16-16V96h32Z">
                                    </path>
                                </svg>
                                <p>Produtos</p>
                            </a>
                        </li>
                        <?php
                    endif;
                    ?>

                    <?php
                    if (($userlogin['user_level'] == 2) || ($userlogin['user_level'] == 3)):
                        ?>

                        <li class="menu-item" :class="{'active' : activeMenu === 'usuarios'}">
                            <a href="javascript:void(0);" class="menu-link menu-toggle"
                                @click="activeMenu === 'usuarios' ? activeMenu = null : activeMenu = 'usuarios'">
                                <svg xmlns="https://www.w3.org/2000/svg" class="menu-icon" width="20" height="20"
                                    fill="currentcolor" viewbox="0 0 256 256">
                                    <path
                                        d="M184,112a8,8,0,0,1-8,8H112a8,8,0,0,1,0-16h64A8,8,0,0,1,184,112Zm-8,24H112a8,8,0,0,0,0,16h64a8,8,0,0,0,0-16Zm48-88V208a16,16,0,0,1-16,16H48a16,16,0,0,1-16-16V48A16,16,0,0,1,48,32H208A16,16,0,0,1,224,48ZM48,208H72V48H48Zm160,0V48H88V208H208Z">
                                    </path>
                                </svg>
                                <p>Usuários</p>
                            </a>
                            <ul class="menu-sub" x-cloak x-show="activeMenu === 'usuarios'" x-collapse>

                                <li class="menu-item">
                                    <a href="painel.php?exe=users/index" class="menu-link">
                                        <p>Listar/Editar</p>
                                    </a>
                                </li>

                                <?php
                                if ($userlogin["user_level"] == 3):
                                    ?>
                                    <li class="menu-item">
                                        <a href="painel.php?exe=users/create" class="menu-link">
                                            <p>Cadastrar</p>
                                        </a>
                                    </li>
                                    <?php
                                endif;
                                ?>
                            </ul>
                        </li>
                        <?php
                    endif;
                    ?>

                    <?php
                    if ($userlogin['user_level'] == 3):
                        ?>
                        <li class="menu-item" :class="{'active' : activeMenu === 'configuracoes'}">
                            <a href="painel.php?exe=configuracoes/index" class="menu-link"
                                @click="activeMenu === 'configuracoes' ? activeMenu = null : activeMenu = 'configuracoes'">
                                <svg xmlns="https://www.w3.org/2000/svg" class="menu-icon" width="20" height="20"
                                    fill="currentcolor" viewbox="0 0 256 256">
                                    <path
                                        d="M216,80H184V48a16,16,0,0,0-16-16H40A16,16,0,0,0,24,48V176a8,8,0,0,0,13,6.22L72,154V184a16,16,0,0,0,16,16h93.59L219,230.22a8,8,0,0,0,5,1.78,8,8,0,0,0,8-8V96A16,16,0,0,0,216,80ZM66.55,137.78,40,159.25V48H168v88H71.58A8,8,0,0,0,66.55,137.78ZM216,207.25l-26.55-21.47a8,8,0,0,0-5-1.78H88V152h80a16,16,0,0,0,16-16V96h32Z">
                                    </path>
                                </svg>
                                <p>Configurações</p>
                            </a>
                        </li>
                        <?php
                    endif;
                    ?>
                </ul>
            </nav>

            <div class="main-content space-y-6 pt-2">

                <div
                    class="flex items-center gap-2 rounded-lg bg-white px-4 py-3 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
                    <button type="button" @click="$store.app.toggleSidebar()"
                        class="flex h-9 w-9 flex-none items-center justify-center rounded-lg bg-slate-100 transition-all duration-300 hover:bg-slate-200 hover:text-indigo-600 dark:bg-white/5 dark:hover:bg-lightindigo dark:hover:text-white lg:hidden">
                        <svg xmlns="https://www.w3.org/2000/svg" width="20" height="20" fill="currentcolor"
                            viewbox="0 0 256 256">
                            <path
                                d="M224,128a8,8,0,0,1-8,8H40a8,8,0,0,1,0-16H216A8,8,0,0,1,224,128ZM40,72H216a8,8,0,0,0,0-16H40a8,8,0,0,0,0,16ZM216,184H40a8,8,0,0,0,0,16H216a8,8,0,0,0,0-16Z">
                            </path>
                        </svg>
                    </button>
                    <div class="flex flex-1 items-center justify-between gap-2">
                        <div class="flex items-center gap-2"></div>
                        <div class="flex flex-none items-center gap-2">
                            <div class="relative">
                                <button
                                    class="flex h-9 w-9 items-center justify-center rounded-lg bg-slate-100 transition-all duration-300 hover:bg-slate-200 hover:text-indigo-600 dark:bg-white/5 dark:hover:bg-lightindigo dark:hover:text-white"
                                    x-cloak x-show="$store.app.mode === 'light'" @click="$store.app.toggleMode('dark')">
                                    <svg xmlns="https://www.w3.org/2000/svg" width="20" height="20" fill="currentcolor"
                                        viewbox="0 0 256 256">
                                        <path
                                            d="M233.54,142.23a8,8,0,0,0-8-2,88.08,88.08,0,0,1-109.8-109.8,8,8,0,0,0-10-10,104.84,104.84,0,0,0-52.91,37A104,104,0,0,0,136,224a103.09,103.09,0,0,0,62.52-20.88,104.84,104.84,0,0,0,37-52.91A8,8,0,0,0,233.54,142.23ZM188.9,190.34A88,88,0,0,1,65.66,67.11a89,89,0,0,1,31.4-26A106,106,0,0,0,96,56,104.11,104.11,0,0,0,200,160a106,106,0,0,0,14.92-1.06A89,89,0,0,1,188.9,190.34Z">
                                        </path>
                                    </svg>
                                </button>
                                <button
                                    class="flex h-9 w-9 items-center justify-center rounded-lg bg-slate-100 transition-all duration-300 hover:bg-slate-200 hover:text-indigo-600 dark:bg-white/5 dark:hover:bg-lightindigo dark:hover:text-white"
                                    x-cloak x-show="$store.app.mode === 'dark'" @click="$store.app.toggleMode('light')">
                                    <svg xmlns="https://www.w3.org/2000/svg" width="20" height="20" fill="currentcolor"
                                        viewbox="0 0 256 256">
                                        <path
                                            d="M120,40V16a8,8,0,0,1,16,0V40a8,8,0,0,1-16,0Zm72,88a64,64,0,1,1-64-64A64.07,64.07,0,0,1,192,128Zm-16,0a48,48,0,1,0-48,48A48.05,48.05,0,0,0,176,128ZM58.34,69.66A8,8,0,0,0,69.66,58.34l-16-16A8,8,0,0,0,42.34,53.66Zm0,116.68-16,16a8,8,0,0,0,11.32,11.32l16-16a8,8,0,0,0-11.32-11.32ZM192,72a8,8,0,0,0,5.66-2.34l16-16a8,8,0,0,0-11.32-11.32l-16,16A8,8,0,0,0,192,72Zm5.66,114.34a8,8,0,0,0-11.32,11.32l16,16a8,8,0,0,0,11.32-11.32ZM48,128a8,8,0,0,0-8-8H16a8,8,0,0,0,0,16H40A8,8,0,0,0,48,128Zm80,80a8,8,0,0,0-8,8v24a8,8,0,0,0,16,0V216A8,8,0,0,0,128,208Zm112-88H216a8,8,0,0,0,0,16h24a8,8,0,0,0,0-16Z">
                                        </path>
                                    </svg>
                                </button>
                            </div>
                            <div class="relative" x-data="dropdown" @click.outside="open = false">
                                <button type="button" class="flex items-center gap-1.5 xl:gap-0" @click="toggle()">
                                    <span class="hidden xl:block"><?= $userlogin['user_name']; ?>
                                        <?= $userlogin['user_lastname']; ?></span>
                                    <svg xmlns="https://www.w3.org/2000/svg" class="ms-1 hidden md:block" width="20"
                                        height="20" fill="currentcolor" viewbox="0 0 256 256">
                                        <path
                                            d="M213.66,101.66l-80,80a8,8,0,0,1-11.32,0l-80-80A8,8,0,0,1,53.66,90.34L128,164.69l74.34-74.35a8,8,0,0,1,11.32,11.32Z">
                                        </path>
                                    </svg>
                                </button>
                                <ul class="absolute right-0 top-11 z-10 mt-2 w-40 min-w-[190px] rounded bg-white p-2 text-sm text-slate-400 shadow-md dark:bg-[#323249]"
                                    x-cloak x-show="open" x-transition x-transition.duration.300ms>
                                    <li class="my-1 block h-px bg-slate-200 dark:bg-gray-100/10"></li>
                                    <li>
                                        <a href="painel.php?logoff=true"
                                            class="flex items-center px-4 py-2 text-red-600 transition-all duration-300 hover:bg-slate-100 dark:hover:bg-black/10">
                                            <svg xmlns="https://www.w3.org/2000/svg" class="mr-2" width="16" height="16"
                                                fill="currentcolor" viewbox="0 0 256 256">
                                                <path
                                                    d="M112,216a8,8,0,0,1-8,8H48a16,16,0,0,1-16-16V48A16,16,0,0,1,48,32h56a8,8,0,0,1,0,16H48V208h56A8,8,0,0,1,112,216Zm109.66-93.66-40-40a8,8,0,0,0-11.32,11.32L196.69,120H104a8,8,0,0,0,0,16h92.69l-26.35,26.34a8,8,0,0,0,11.32,11.32l40-40A8,8,0,0,0,221.66,122.34Z">
                                                </path>
                                            </svg>
                                            Sair
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <?php
                //QUERY STRING
                if (!empty($getexe)):
                    $includepatch = __DIR__ . DIRECTORY_SEPARATOR . 'system' . DIRECTORY_SEPARATOR . strip_tags(trim($getexe) . '.php');
                else:
                    $includepatch = __DIR__ . DIRECTORY_SEPARATOR . 'system' . DIRECTORY_SEPARATOR . 'home.php';
                endif;

                if (file_exists($includepatch)):
                    require_once($includepatch);
                else:
                    echo "<div class=\"content notfound\">";
                    WSErro("<b>Erro ao incluir tela:</b> Erro ao incluir o controller /{$getexe}.php!", WS_ERROR);
                    echo "</div>";
                endif;
                ?>

                <footer class="flex flex-wrap items-center justify-center gap-3 px-4 pb-4 sm:justify-between">
                    <p class="text-sm text-slate-400">&copy; 2023 desenvolvido por <a href="https://edgarmagalhaes.com"
                            target="_blank">Edgar Magalhães</a></p>
                </footer>

            </div>

        </div>
    </div>

    <script src="assets/js/alpine-collaspe.min.js"></script>
    <script src="assets/js/alpine-persist.min.js"></script>
    <script defer src="assets/js/cdn.min.js"></script>
    <script src="assets/js/alpine.min.js" defer></script>

    <script src="assets/js/perfect-scrollbar.min.js"></script>

    <script src="assets/js/apexcharts.js"></script>
    <script src="assets/js/financecharts.js"></script>

    <script src="assets/js/custom.js"></script>
</body>

</html>
<?php
ob_end_flush();
