<div class="min-h-[calc(100vh-152px)]">
    <?php
    $post = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    if (isset($post) && $post['SendPostForm']) :
        unset($post['SendPostForm']);

        require('_models/Caixa.class.php');
        $cadastra = new Caixa;
        $cadastra->ExeCreate($post);

        if ($cadastra->getResult()) :
            header('Location: painel.php?exe=financeiro/index_caixa&create=true');
        else :
            WSErro($cadastra->getError()[0], $cadastra->getError()[1]);
        endif;
    endif;
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Caixa</h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Abrir caixa</h5>
            <form name="PostForm" action="" method="post" enctype="multipart/form-data">
                <input type="hidden" name="caixa_user" value="<?= $userlogin['user_id']; ?>" />                
                <input type="hidden" name="caixa_situacao" value="1" /> 
                <div class="grid grid-cols-3 gap-5">
                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Informe o valor em dinheiro</label>
                        <input type="text" class="form-input" name="caixa_valor" placeholder="Informe o valor em dinheiro" value="<?php if (isset($post['caixa_valor'])) echo $post['caixa_valor']; ?>" autofocus>
                    </div>
                </div>
                <div>
                    <br />
                    <input type="submit" class="btn border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 dark:disabled:bg-white/10 dark:disabled:border-white/10 disabled:bg-gray-300 disabled:border-gray-300 hover:bg-indigo-700" value="Cadastrar" name="SendPostForm" />
                </div>
            </form>
        </div>
    </div>
</div>