<?php

/**
 * Configurações.class [ MODEL ADMIN ]
 * Respnsável por gerenciar os configurações no Admin do sistema!
 * 
 * @copyright (c) 2023, Edgar C. Magalhães
 */
class Configuracoes
{

    private $Data;
    private $Post;
    private $Error;
    private $Result;

    //Nome da tabela no banco de dados
    const Entity = DB_CONFIG;

    /**
     * <b>Atualizar Post:</b> Envelope os dados em uma array atribuitivo e informe o id de um 
     * post para atualiza-lo na tabela!
     * @param INT $PostId = Id do post
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeUpdate($PostId, array $Data)
    {
        $this->Post = (int) $PostId;
        $this->Data = $Data;
        $this->setData();
        $this->Update();
    }

    /**
     * <b>Verificar Cadastro:</b> Retorna ID do registro se o cadastro for efetuado ou FALSE se não.
     * Para verificar erros execute um getError();
     * @return BOOL $Var = InsertID or False
     */
    public function getResult()
    {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com uma mensagem e o tipo de erro.
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError()
    {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    //Valida e cria os dados para realizar o cadastro
    private function setData()
    {
        $this->Data = array_map('strip_tags', $this->Data);
        $this->Data = array_map('trim', $this->Data);
    }

    //Atualiza o post no banco!
    private function Update()
    {
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE id_conf = :id", "id={$this->Post}");
        if ($Update->getResult()) :
            $this->Error = ["A configuração foi atualizada com sucesso no sistema!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }
}
